package gov.va.med.mhv.integration.phr.stage.transfer;

import gov.va.med.mhv.integration.phr.stage.enumeration.StageMessageFormatType;
import gov.va.med.mhv.integration.phr.stage.enumeration.StageMessagePriorityType;
import gov.va.med.mhv.integration.phr.stage.enumeration.StageMessageStatusType;
import gov.va.med.mhv.integration.phr.stage.enumeration.StageRoutingStatusType;

import java.util.Date;

/**
 * User: Rob Murtha 
 */
public class StageMessageControl extends StageEntity  {
    // Fields
	private String messageName;
	private Date messageDate=new Date();
	private String extractType;
	private Date startDate;
	private Date endDate;
	private Long recordCount=0L;
	private String messageStatus = StageMessageStatusType.NEW;;
	private String routingStatus = StageRoutingStatusType.NEW;
	private String messageFormat = StageMessageFormatType.SQL;;
	private String messageHeader;
	private String messageBody;
    private String messageType;
    private String errorMessage;
    private Long retryCount=0L;
    private Integer priority = StageMessagePriorityType.HIGH;


    // Constructors	    
	public StageMessageControl() {
	}

	/** minimal constructor */
	public StageMessageControl( String messageName,  long recordCount,
                                String routingStatus, String messageType,
                                String icn, String stationNumber, String extractType,                                
                                Date startDate, Date endDate) {
        this.routingStatus = routingStatus;
        this.messageType = messageType;
        this.messageName = messageName;
        this.recordCount = recordCount;
        this.icn = icn;
        this.stationNumber = stationNumber;
        this.extractType = extractType;
        this.startDate=startDate;
        this.endDate=endDate;
    }


    public StageMessageControl(String messageName, String routingStatus, String messageType, String icn, String extractType) {
        this.messageName = messageName;
        this.routingStatus = routingStatus;
        this.messageType = messageType;
        this.icn=icn;
        this.extractType=extractType;
    }


    // Property accessors


	public String getMessageName() {
		return this.messageName;
	}

	public void setMessageName(String messageName) {
		this.messageName = messageName;
	}

    /** @see gov.va.med.mhv.integration.phr.stage.enumeration.StageMessageStatusType */
    public String getMessageType() {
        return messageType;
    }

    /** @see gov.va.med.mhv.integration.phr.stage.enumeration.StageMessageStatusType */
    public void setMessageType(String messageType) {
        this.messageType = messageType;
    }
    

	public Date getMessageDate() {
		return this.messageDate;
	}

	public void setMessageDate(Date messageDate) {
		this.messageDate = messageDate;
	}

    /** @see gov.va.med.mhv.integration.phr.stage.enumeration.StageExtractStatusType */
    public String getExtractType() {
		return this.extractType;
	}

	/** @see gov.va.med.mhv.integration.phr.stage.enumeration.StageExtractStatusType */
    public void setExtractType(String extractType) {
		this.extractType = extractType;
	}

	public Date getStartDate() {
		return this.startDate;
	}

	public void setStartDate(Date startDate) {
		this.startDate = startDate;
	}

	public Date getEndDate() {
		return this.endDate;
	}

	public void setEndDate(Date endDate) {
		this.endDate = endDate;
	}

	public Long getRecordCount() {
		return this.recordCount;
	}

	public void setRecordCount(Long recordCount) {
		this.recordCount = recordCount;
	}

    /** @see gov.va.med.mhv.integration.phr.stage.enumeration.StageMessageStatusType */
    public String getMessageStatus() {
		return this.messageStatus;
	}

    /** @see gov.va.med.mhv.integration.phr.stage.enumeration.StageMessageStatusType */
    public void setMessageStatus(String messageStatus) {
		this.messageStatus = messageStatus;
	}

    /** @see gov.va.med.mhv.integration.phr.stage.enumeration.StageRoutingStatusType */
    public String getRoutingStatus() {
		return this.routingStatus;
	}

    /** @see gov.va.med.mhv.integration.phr.stage.enumeration.StageRoutingStatusType */
    public void setRoutingStatus(String routingStatus) {
		this.routingStatus = routingStatus;
	}

    /** @see gov.va.med.mhv.integration.phr.stage.enumeration.StageMessageFormatType */
    public String getMessageFormat() {
		return this.messageFormat;
	}

    /** @see gov.va.med.mhv.integration.phr.stage.enumeration.StageMessageFormatType */
    public void setMessageFormat(String messageFormat) {
		this.messageFormat = messageFormat;
	}

	public String getMessageHeader() {
		return this.messageHeader;
	}

	public void setMessageHeader(String messageHeader) {
		this.messageHeader = messageHeader;
	}

	public String getMessageBody() {
		return this.messageBody;
	}

	public void setMessageBody(String messageBody) {
		this.messageBody = messageBody;
	}

    public void setErrorMessage(String description) {
        this.errorMessage = description;
    }

    public String getErrorMessage() {
        return errorMessage;
    }

    public Long getRetryCount() {
        return retryCount;
    }

    public void setRetryCount(Long retryCount) {
        this.retryCount = retryCount;
    }

    public Integer getPriority() {
        return priority;
    }

    public void setPriority(Integer priority) {
        this.priority = priority;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer(super.toString());
        sb.append(" ").append(
        "StageMessageControl{" +
                "messageName='" + messageName + '\'' +
                ", messageDate=" + messageDate +
                ", extractType='" + extractType + '\'' +
                ", startDate=" + startDate +
                ", endDate=" + endDate +
                ", recordCount=" + recordCount +
                ", messageStatus='" + messageStatus + '\'' +
                ", routingStatus='" + routingStatus + '\'' +
                ", messageFormat='" + messageFormat + '\'' +
                ", messageHeader='" + messageHeader + '\'' +
                ", messageBody='" + messageBody + '\'' +
                ", messageType='" + messageType + '\'' +
                ", errorMessage='" + errorMessage + '\'' +
                ", retryCount=" + retryCount + '\'' +
                ", priority=" + priority +
                '}'
                );
        return sb.toString();
    }
}
